﻿
/// <reference path="../SimpleService/SimpleService.aspx" />

//defined in SimpleService.aspx
//var serviceSelectId = '<%=serviceSelect.ClientID %>';

function pageLoad()
{
    //adds lookup handler to lookup button
    $addHandler($get("lookupButton"),"click",lookup);
    
    //adds save handler to save button
    $addHandler($get("saveButton"),"click",saveForm);
    
    //adds clear handler to clear button
    $addHandler($get("clearButton"),"click",clearForm);
    
}

function lookup(e)
{
    var service;
    switch(getServiceSelectText())
    {
        case "WCF Service":
            tempuri.org.SimpleService.LookupCustomer($get("customerId").value,onSuccessLookup,onFailed);
            break;
        case "Internal WCF Service":
            service = new ServiceCommunication.SimpleWCFService();
            service.lookupCustomer($get("customerId").value,onSuccessLookup,onFailed);
            break;
    } 

}

function getServiceSelectText()
{
    var serviceSelector = $get(serviceSelectId);
    return serviceSelector.options[serviceSelector.selectedIndex].text;
}

function saveRow(e)
{
    var elementId = e.target.id;
    var markerLocation = elementId.indexOf(':') + 1;
    var entityId = elementId.substring(markerLocation);

    //create new customer
    var customer = new ServiceData.Simple.Customer();
    
    //get data from form
    customer.FirstName = $get("customerId" + ":" + entityId).value;
    customer.FirstName = $get("firstName" + ":" + entityId).value;
    customer.LastName = $get("lastName"  + ":" + entityId).value;
    customer.Address = $get("address" + ":" + entityId).value;
    customer.City = $get("city" + ":" + entityId).value;
    customer.State = $get("state" + ":" + entityId).value;
    customer.Zip = $get("zip" + ":" + entityId).value;

    save(customer);
    
}


function saveForm(e)
{
    //create new customer
    var customer = new ServiceData.Simple.Customer();
    
    //get data from form
    customer.CustomerId = ("customerId").value;
    if(customer.CustomerId === "")
        customer.CustomerId = 0;
    customer.FirstName = $get("firstName").value;
    customer.LastName = $get("lastName").value;
    customer.Address = $get("address").value;
    customer.City = $get("city").value;
    customer.State = $get("state").value;
    customer.Zip = $get("zip").value;

    save(customer);
}

function save(customer)
{
    var service;
    switch(getServiceSelectText())
    {
        case "WCF Service":
            tempuri.org.SimpleService.SaveCustomer(customer,onSuccessSave,onFailed);
            break;
        case "Internal WCF Service":
            service = new ServiceCommunication.SimpleWCFService();
            service.saveCustomer(customer,onSuccessSave,onFailed);
            break;
    } 
}


function clearForm(e)
{
    var customerId = $get("customerId");
    customerId.value = "";
    customerId.readOnly = false;
    $get("firstName").value = "";
    $get("lastName").value = "";
    $get("address").value= "";
    $get("city").value= "";
    $get("state").value= "";
    $get("zip").value= "";
    
}

function onSuccessSave(result)
{
    //send new date to table builder
    createTableEntries(result);
    clearForm();
}

function onSuccessLookup(result)
{
    if(result === null)
    {
        alert("No results found");
        return;
    }
    clearForm();
    populateForm(result);
}

function onFailed(error)
{
    alert("An error occured \n"  + error.get_message());
}

function populateForm(customer)
{
    //populate form with results
    var customerId = $get("customerId");
    customerId.value = customer.CustomerId;
    customerId.readOnly = true;
    $get("firstName").value = customer.FirstName;
    $get("lastName").value = customer.LastName;
    $get("address").value = customer.Address;
    $get("city").value = customer.City;
    $get("state").value = customer.State;
    $get("zip").value = customer.Zip;

}
function createTableEntries(customer)
{
   var addedTable = $get("addedCustomersTable");
   var newRow = addedTable.insertRow();
   var cell;
   
   //add customerId
   cell = newRow.insertCell();
   createTextBoxWithHandler(true,cell,customer.CustomerId,"customerId",customer.CustomerId);  
   
   //add firstName
   cell = newRow.insertCell();
   createTextBoxWithHandler(false,cell,customer.CustomerId,"firstName",customer.FirstName);  

   //add lastName
   cell = newRow.insertCell();
   createTextBoxWithHandler(false,cell,customer.CustomerId,"lastName",customer.LastName);  

   //add address
   cell = newRow.insertCell();
   createTextBoxWithHandler(false,cell,customer.CustomerId,"address",customer.Address);  

   //add city
   cell = newRow.insertCell();
   createTextBoxWithHandler(false,cell,customer.CustomerId,"city",customer.City);  

   //add state
   cell = newRow.insertCell();
   createTextBoxWithHandler(false,cell,customer.CustomerId,"state",customer.State);  

   //add zip
   cell = newRow.insertCell();
   createTextBoxWithHandler(false,cell,customer.CustomerId,"zip",customer.Zip);  

}

function createTextBoxWithHandler(readOnly, parentElement, id, fieldName, value) {
  var newInput = document.createElement('input');
  var inputId = fieldName + ":" + id;
  newInput.setAttribute('id',inputId);
  newInput.setAttribute('type','text');
  newInput.setAttribute('value',value);
  if(readOnly === true)
    newInput.readOnly = true;
  parentElement.appendChild(newInput);
  $addHandler(newInput,"change",saveRow);
}

